////////////////////////////////////////////////////////////////////////////////
//BFFInfo
////////////////////////////////////////////////////////////////////////////////
class DFFI extends Actor;

var	DFFI	NextBFFI,PrevBFFI;
var	Pawn	PawnOwner;
var	bool	bMaster;	//use this to NOT remove Master from the list in Tick
var	DFF	BFFT;	//link back to mutator for variable retrieval
var	bool	bfatter;	//use this to alternate between growing skinny/fat
var	bool	bfSPdone;	//use this to disable spawning effects when finished
var	bool	bmoving;	//use this to set max/min protection time
var	float	oldx,oldy;	//player locations to detect movement

//==============================================================================
//	STATES
var	float	fSP,	//is player spawning (protection period)
			fSS1,	//is player shooting spawners (penalty period)
			fSS2;	//is player spawning and shooting others (penalty period)
//	SCORING ESSENTIALS
var	int		iHS,		//headshots since last death
			iSS1,iSS2;	//number of shots in penalty period
//	STATISTICS
var	int		iTVSH,		//total valid shots
			iTHS,		//total headshots
			iTSS1,		//total SS1 states
			iTSS2,		//total SS2 states
			iTSHSS1,	//total shots in SS1 state (or to activate state)
			iTSHSS2;	//total shots in SS2 state (or to activate state)
//	BONUS/PENALTY POINT STATISTICS
var	int		iTBPP,		//total pos bonus points applied
			iTBPN,		//total neg penalty points
			iTBPTP,		//total pos bonus points applied towards team score
			iTBPTN;		//total neg bonus points applied towards team score
//==============================================================================

function DFFI FindInfo(Pawn MyPawn)
{
	local DFFI bffi;

	for (bffi=NextBFFI; bffi!=none ; bffi=bffi.NextBFFI)
	{
		if(bffi.PawnOwner==MyPawn)
			break;
	}
	return bffi;
}

//checks to make sure players have a BFFInfo when spawned through modifyplayer
function VerifyInfo(Pawn MyPawn)
{
	local	DFFI	bffi,newbffi;

	if(NextBFFI==none)
	{
		newbffi=spawn(class'DFFI',MyPawn);
		newbffi.PrevBFFI=self;
		newbffi.BFFT=BFFT;
		NextBFFI=newbffi;
		newbffi.Activate1();
	}

	else
	{
		for (bffi=NextBFFI; bffi!=none ; bffi=bffi.NextBFFI)
	    {
			if(bffi.PawnOwner==MyPawn)
			{
				bffi.Activate();
				break;
			}

			if(bffi.NextBFFI==none)
			{
				newbffi=spawn(class'DFFI',MyPawn);
				newbffi.PrevBFFI=bffi;
				newbffi.BFFT=BFFT;
				bffi.NextBFFI=newbffi;
				newbffi.Activate1();
				break;
			}
	    }
	}
}

function RemoveFromList()
{
	if(NextBFFI!=none)
	{
		PrevBFFI.NextBFFI=NextBFFI;
		NextBFFI.PrevBFFI=PrevBFFI;
	}

	else
	{
		PrevBFFI.NextBFFI=none;
	}

	Destroy();
}

function Activate1()
{
	PawnOwner=Pawn(Owner);
	Activate();
}

function Activate()
{
	fSP=BFFT.MaxProtectTime;
	bfSPdone=false;
	bmoving=false;
	oldx=PawnOwner.Location.X;
	oldy=PawnOwner.Location.Y;
	if(BFFT.bTranslucentSpawn)
	{
		PawnOwner.Style=STY_Translucent;
		//consider adding .ambientglow, can do pulsing effect too with 255
		if(BFFT.Glow>=0 && BFFT.Glow<=100)
			PawnOwner.ScaleGlow=BFFT.Glow;
	}
	if(BFFT.bFat)
	{
		PawnOwner.Fatness=PawnOwner.default.Fatness-(BFFT.Fat/2);
		bfatter=true;
	}
	BFFT.PlayMedia(60,PawnOwner,PawnOwner);
	//need to see if BFFMaster.BFFM.sndSpawnSound is set...
	//if(BFFT.bSpawnSound)
	if(BFFT.BFFM.sndSpawnSound!=none)
	{
		//PawnOwner.AmbientSound=sound'BFFSound.Spawn1';
		PawnOwner.AmbientSound=BFFT.BFFM.sndSpawnSound;
		PawnOwner.SoundPitch=64;
		PawnOwner.SoundRadius=15;
		PawnOwner.SoundVolume=128;
	}
	SetTimer(0.1,true);
}

function Timer()
{
	//if it gets this far without a valid pawnowner, we may have a problem.
	//recode to check pawnowner earlier in the chain (in activate?). maybe
	//change to if(Pawn(Owner)==none) instead...
	if(PawnOwner==none)
	{
		SetTimer(0,false);
		RemoveFromList();
		return;
	}

	if(!bfSPdone)
	{
		fSP-=0.1;
		if(fSP<=0)
		{
			bfSPdone=true;
			if(BFFT.bTranslucentSpawn)
			{
				PawnOwner.Style=PawnOwner.default.Style;
				PawnOwner.ScaleGlow=PawnOwner.default.ScaleGlow;
			}
			if(BFFT.bFat)
				PawnOwner.Fatness=PawnOwner.default.Fatness;
			//need to see if BFFMaster.BFFM.sndSpawnSound is set...
			//if(BFFT.bSpawnSound)
			if(BFFT.BFFM.sndSpawnSound!=none)
			{
				PawnOwner.AmbientSound=PawnOwner.default.AmbientSound;
				PawnOwner.SoundPitch=PawnOwner.default.SoundPitch;
				PawnOwner.SoundRadius=PawnOwner.default.SoundRadius;
				PawnOwner.SoundVolume=PawnOwner.default.SoundVolume;
			}
			BFFT.PlayMedia(50,PawnOwner,PawnOwner);
		}
		else
		{
			if(BFFT.bFat && bfatter)
			{
				PawnOwner.Fatness+=BFFT.Fat/10;
				if(PawnOwner.Fatness>=PawnOwner.default.Fatness)
					bfatter=false;
			}
			else if(BFFT.bFat && !bfatter)
			{
				PawnOwner.Fatness-=BFFT.Fat/10;
				if(PawnOwner.Fatness<=PawnOwner.default.Fatness-(BFFT.Fat*2))
					bfatter=true;
			}
			if(!bmoving && (PawnOwner.Location.X!=oldx || PawnOwner.Location.Y!=oldy))
			{
				bmoving=true;
				if(fSP>BFFT.MinProtectTime)
					fSP=BFFT.MinProtectTime;
			}
		}
	}

	if(fSS1>0)
		fSS1-=0.1;

	if(fSS2>0)
		fSS2-=0.1;
}

defaultproperties
{
	bHidden=True
}
